var LTRem = {
    el: document.getElementById('LTRem'),
    defaultSize: 750,
    setSize: function(size) {
        // 设置计算尺寸
        // size: 计算尺寸
        this.size = parseInt(size) || this.defaultSize;
        this.remReSize();
    },
    remReSize: function() {
        var t = (document.documentElement.clientWidth / this.size).toFixed(2);
        document.documentElement.style.setProperty('font-size', 100 * t + 'px');
        // 浏览器默认字号16，6.25 * 16 = 100px = 1rem
    },
    init: function() {
        var size = this.defaultSize;
        if(this.el) {
            size = parseInt(this.el.getAttribute('data-size') || this.defaultSize);
        }
        this.setSize(size);
        window.addEventListener('resize', function () {
            LTRem.remReSize();
        }, false);
    }
};

LTRem.init();