$(function() {
    modal.init();
    page.init();
})

function getQueryVariable(variable) {
    var query = window.location.search.substring(1);
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) { return pair[1]; }
    }
    return (false);
}

// 是否pc
function IsPc() {
    if (!navigator.userAgent.match(/AppleWebKit.*Mobile.*/)) {
        // pc
        return true
    }
    return false
}

// 是否微信
function isWeChat() {
    if (typeof WeixinJSBridge !== "undefined") {
        return 1;
    }
    return 0;
}

// 是否ios 
function isiOS() {
    var isPc = IsPc();
    if (!isPc) {
        var u = navigator.userAgent;
        // var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS
    }
}

// 联系qq客服
function onQQService() {
    var jhKfQQ = 3563681140;
    if (isWeChat()) {
        alert("请在浏览器打开页面")
        return;
    }
    var isPc = IsPc();
    var urlMobil = `mqqwpa://im/chat?chat_type=wpa&uin=${jhKfQQ}&version=1&src_type=web&web_src=http:://wpa.b.qq.com`;
    var urlPc = `http://wpa.qq.com/msgrd?v=3&uin=${jhKfQQ}&site=qq&menu=yes`;
    var url = isPc ? urlPc : urlMobil;
    window.open(url, "_brank");
}

if (getQueryVariable('id')) {
    $('.header-elements').removeClass('hid');
}
var page = {
    appointCodeBase64: '',
    appointTeamCodeBase64: '',
    tipModalDes: [
        '为了更好的体验<br>请前往移动端参与活动',
        '扫一扫下载《问道》手游<br>完成预创角 领取预创角礼包'
    ],
    init: function() {
        // 卖点图
        if ($('.main-swiper .swiper-slide').length > 0) {
            var mainSwiper = new Swiper('.main-swiper', {
                loop: true,
                autoplay: {
                    disableOnInteraction: false
                },
                effect: 'coverflow',
                centeredSlides: true,
                slidesPerView: 'auto',
                followFinger: true,
                slideToClickedSlide: true,
                coverflowEffect: {
                    rotate: 0,
                    stretch: 0,
                    depth: 140,
                    modifier: 2,
                    slideShadows: true
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });
        }

        // 弹窗
        $(".btn-code-modal[data-type]").on('click', function() {
            var tip = parseInt($(this).attr('data-tip'));
            if (tip == 1) {
                modal.open('.tip-modal');
            }
            if (tip == 0) {
                modal.open('.download-modal');
            }
            // ios ios 敬请期待
            if (tip == 2) {
                modal.open('.ios-tips-modal');
            }
        });

        // 联系客服 qq
        $(".qq-icon").on("click", function() {
            onQQService()
        })

        // android 下载
        $('.ico-btn-android').on("click", function() {
            if (isiOS()) {
                $('.ico-btn-ios').click()
                return
            }
            window.open('https://game.jhfly.cn/download/wcfml_20210826_mid.apk')
        })
    }
}

/*模态框相关*/
var modal = {
    preModal: '', // 当前\上一个开启的模态框的类名
    scrollWidth: '', // 浏览器滚动条宽度
    scrollTop: 0, // 开启模态框时页面滚动距离
    needCloseModal: '', // 需要关闭的模态框类名
    closeIng: false, // 是否正在关闭模态框
    delayTime: 300, // 模态框关闭所需时间
    preVideo: '', // 保存'video-data'中需要自动播放的video的Id
    focusEl: '', // 开启模态框前获取到焦点的元素
    opening: false, // 当前是否有开启的模态框
    scrollThrough: false, // 是否阻止滚动穿透
    open: function(className) {
        var that = this;

        // 若当前有开启的模态框，则关闭当前模态框后再开启需要开启的模态框
        if (that.opening) {
            that.hide(that.preModal);
            setTimeout(function() {
                that.open(className);
            }, that.delayTime);
            return;
        }
        that.opening = true;

        var openDalyTime = 0;
        if (that.closeIng) {
            openDalyTime = that.delayTime;
        }
        setTimeout(function() {
            that.preModal = className;
            that.focusEl = document.activeElement;
            that.scrollWidth = window.innerWidth - document.body.clientWidth;
            that.scrollTop = parseInt(that.getScrollTop());

            $('body').css('padding-right', that.scrollWidth + 'px');
            if (that.scrollThrough) {
                document.body.style.top = -that.scrollTop + 'px';
                $('body').addClass('modal-open');
            } else {
                $('body').addClass('modal-open-scroll-through');
            }

            $(that.preModal).css('display', 'flex').addClass('modal-active');
            $(that.needCloseModal).removeClass('modal-hide');

            /* 开启模态框后为当前模态框的关闭按钮获取焦点 */
            $(className + " [data='close']").focus();
        }, openDalyTime)
    },
    hide: function(className) {
        var that = this;
        that.needCloseModal = className;
        that.closeIng = true;

        $(that.needCloseModal).removeClass('modal-active').addClass('modal-hide');

        setTimeout(function() {
            $(that.focusEl).focus();
            $(that.needCloseModal).css('display', 'none');
            that.scrollTo(that.scrollTop);

            if (that.scrollThrough) {
                $('body').removeClass('modal-open');
            } else {
                $('body').removeClass('modal-open-scroll-through');
            }

            $(that.preModal).css('overflow', '');
            $('body').css('padding-right', '');
            that.closeIng = false;
            that.opening = false;
        }, that.delayTime);

        /*if you need auto play video*/
        /*if(document.getElementById(that.preVideo) != null) {
            document.getElementById(that.preVideo).pause();
        }*/
    },
    scrollTo: function(num) {
        document.body.scrollTop = document.documentElement.scrollTop = num;
    },
    getScrollTop: function() {
        return window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
    },
    init: function() {
        var that = this;
        $('.modal').css('display', 'none');
        $('.modal-hide, .modal-hide .modal-wrapper').css('animation-duration', that.delayTime + 'ms');
        // 点击关闭按钮或遮罩层关闭当前模态框
        $("[data='close'], .modal:not([data-click-mask='false'])").on('click', function() {
            that.hide(that.preModal);
        });
        // 阻止点击触发关闭模态框
        $(".modal:not([data-click-mask='false']) .modal-wrapper").on('click', function(e) {
            e.stopPropagation();
        });
        // 点击触发开启模态框
        $("[data-type='modal']").on('click', function() {
            var target = $(this).attr('data');

            /*if you need auto play video*/
            /*that.preVideo = $(this).attr('video-data');
            if(that.preVideo != null) {
                document.getElementById(that.preVideo).play();
            }*/

            that.open(target);
        });
    }
};