/*
 * Decompiled with CFR 0.152.
 */
package com.zee.unity;

import android.annotation.SuppressLint;
import android.util.Log;
import com.zee.unity.ZeeUnityActivity;
import com.zeewain.zeepose.FaceInfo;
import com.zeewain.zeepose.HandInfo;
import com.zeewain.zeepose.HolisticInfo;
import com.zeewain.zeepose.PoseInfo;
import com.zeewain.zeepose.base.Rect;

public class UnityHelper {
    private static final String TAG = "ZeeUnity";
    @SuppressLint(value={"StaticFieldLeak"})
    public static ZeeUnityActivity activity;

    public static void init(ZeeUnityActivity zeeUnityActivity) {
        activity = zeeUnityActivity;
    }

    public static void initUnityScreenSize(int width, int height, String fitSide) {
        activity.initUnityScreenSize(width, height, fitSide);
    }

    public static void openCamera(String cameraId) {
        Log.i((String)TAG, (String)("openCamera() cameraId=" + cameraId));
        UnityHelper.activity.camera2Helper.start(cameraId);
    }

    public static void closeCamera() {
        Log.i((String)TAG, (String)"closeCamera()");
        UnityHelper.activity.camera2Helper.stop();
        activity.clearAllData();
    }

    public static void setTextureViewAlpha(float alpha) {
        Log.i((String)TAG, (String)("setTextureViewAlpha() alpha=" + alpha));
        activity.setTextureViewAlpha(alpha);
    }

    public static void setZeePoseEnable(boolean enable) {
        Log.i((String)TAG, (String)("setZeePoseEnable() enable=" + enable));
        UnityHelper.activity.camera2Helper.setZeePoseEnable(enable);
        activity.clearAllData();
    }

    public static String getVersionNum() {
        return UnityHelper.activity.zeewainPose.getVersionInfo().versionNum;
    }

    public static void setFaceMaxNum(int maxNumFace, int sortType) {
        UnityHelper.activity.zeewainPose.setFaceMaxNum(maxNumFace, sortType);
    }

    public static void setFaceLandmarkStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setFaceLandmarkStatus(status);
    }

    public static void setFaceScoreThreshold(float scoreThresh) {
        UnityHelper.activity.zeewainPose.setFaceScoreThreshold(scoreThresh);
    }

    public static void setFaceSmoothnessStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setFaceSmoothnessStatus(status);
    }

    public static void setHandMaxNum(int maxNumHand, int sortType) {
        UnityHelper.activity.zeewainPose.setHandMaxNum(maxNumHand, sortType);
    }

    public static void setHandLandmarkStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setHandLandmarkStatus(status);
    }

    public static void setHandScoreThreshold(float scoreThresh) {
        UnityHelper.activity.zeewainPose.setHandScoreThreshold(scoreThresh);
    }

    public static void setHandSmoothnessStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setHandSmoothnessStatus(status);
    }

    public static void setSinglePoseSmoothnessStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setSinglePoseSmoothnessStatus(status);
    }

    public static void setPoseSmoothnessStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setPoseSmoothnessStatus(status);
    }

    public static void setPoseTrackNum(int trackNum) {
        UnityHelper.activity.zeewainPose.setPoseTrackNum(trackNum);
    }

    public static void setPoseTrackFrameThreshold(int frameThreshold) {
        Log.i((String)TAG, (String)("setPoseTrackFrameThreshold() frameThreshold=" + frameThreshold));
        UnityHelper.activity.zeewainPose.setPoseTrackFrameThreshold(frameThreshold);
    }

    public static void setPoseRoiScoreThreshold(float roiScoreThreshold) {
        Log.i((String)TAG, (String)("setPoseRoiScoreThreshold() roiScoreThreshold=" + roiScoreThreshold));
        UnityHelper.activity.zeewainPose.setPoseRoiScoreThreshold(roiScoreThreshold);
    }

    public static void setRoiPersonTrackInfo(int x, int y, int width, int height) {
        Log.i((String)TAG, (String)("setRoiPersonTrackInfo() x=" + x + ", y=" + y + ", width=" + width + ", height=" + height));
        activity.clearAllData();
        UnityHelper.activity.roiPersonTrackRect = new Rect(x, y, width, height);
        UnityHelper.activity.useBestPose = false;
        UnityHelper.activity.trackIdArray = null;
    }

    public static void setUseBestPose(boolean useBestPose) {
        Log.i((String)TAG, (String)("setUseBestPose() useBestPose=" + useBestPose));
        activity.clearAllData();
        UnityHelper.activity.useBestPose = useBestPose;
        UnityHelper.activity.trackIdArray = null;
        UnityHelper.activity.roiPersonTrackRect = null;
    }

    public static void setIdPoseTrackIdInfo(int trackId) {
        Log.i((String)TAG, (String)("setIdPoseTrackIdInfo() trackId=" + trackId));
        activity.clearAllData();
        UnityHelper.activity.trackIdArray = new int[]{trackId};
        UnityHelper.activity.roiPersonTrackRect = null;
        UnityHelper.activity.useBestPose = false;
    }

    public static void setTwoPersonTrackInfo(int trackLeftId, int trackRightId) {
        Log.i((String)TAG, (String)("setTwoPersonTrackInfo() trackLeftId=" + trackLeftId + ", trackRightId=" + trackRightId));
        activity.clearAllData();
        UnityHelper.activity.trackIdArray = new int[]{trackLeftId, trackRightId};
        UnityHelper.activity.roiPersonTrackRect = null;
        UnityHelper.activity.useBestPose = false;
    }

    public static void setHolisticFaceLandmarkStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setHolisticFaceLandmarkStatus(status);
    }

    public static void setHolisticBodyLandmarkStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setHolisticBodyLandmarkStatus(status);
    }

    public static void setHolisticHandLandmarkNum(int handLandmarkNum) {
        UnityHelper.activity.zeewainPose.setHolisticHandLandmarkNum(handLandmarkNum);
    }

    public static void setHolisticTrackNum(int trackPersonNum) {
        UnityHelper.activity.zeewainPose.setHolisticTrackNum(trackPersonNum);
    }

    public static void setHolisticTrackFrameThreshold(int frameThresh) {
        UnityHelper.activity.zeewainPose.setHolisticTrackFrameThreshold(frameThresh);
    }

    public static void setHolisticSmoothnessStatus(boolean status) {
        UnityHelper.activity.zeewainPose.setHolisticSmoothnessStatus(status);
    }

    public static int initFace(int modelType, int deviceType, int threadNum) {
        Log.i((String)TAG, (String)("initFace modelType=" + modelType));
        return activity.initFace(modelType, deviceType, threadNum);
    }

    public static int initHand(int modelType, int deviceType, int threadNum) {
        Log.i((String)TAG, (String)("initFace modelType=" + modelType));
        return activity.initHand(modelType, deviceType, threadNum);
    }

    public static int initPersonPose(int modelType, int deviceType, int threadNum, boolean useBestPose) {
        Log.i((String)TAG, (String)("initPersonPose modelType=" + modelType + ", useBestPose=" + useBestPose));
        return activity.initPersonPose(modelType, deviceType, threadNum, useBestPose);
    }

    public static int initSinglePose(int landmarkType, int deviceType, int threadNum) {
        Log.i((String)TAG, (String)("initSinglePose landmarkType=" + landmarkType));
        return activity.initSinglePose(landmarkType, deviceType, threadNum);
    }

    public static int initHolistic(int modelType, int deviceType, int threadNum) {
        Log.i((String)TAG, (String)("initFace modelType=" + modelType));
        return activity.initHolistic(modelType, deviceType, threadNum);
    }

    public static void releaseZeePose() {
        activity.releaseZee();
    }

    public static FaceInfo[] getFaceInfo() {
        return activity.getFaceInfoArray();
    }

    public static FaceInfo[] getOriginalFaceInfo() {
        return activity.getFaceInfoOrgArray();
    }

    public static HandInfo[] getHandInfo() {
        return activity.getHandInfoArray();
    }

    public static HandInfo[] getOriginalHandInfo() {
        return activity.getHandInfoOrgArray();
    }

    public static PoseInfo getSinglePose() {
        if (activity.getPoseInfoArray() != null && activity.getPoseInfoArray().length > 0) {
            return activity.getPoseInfoArray()[0];
        }
        return null;
    }

    public static PoseInfo getOriginalSinglePose() {
        if (activity.getPoseInfoOrgArray() != null && activity.getPoseInfoOrgArray().length > 0) {
            return activity.getPoseInfoOrgArray()[0];
        }
        return null;
    }

    public static PoseInfo[] getPoseInfo() {
        return activity.getPoseInfoArray();
    }

    public static PoseInfo[] getOriginalPoseInfo() {
        return activity.getPoseInfoOrgArray();
    }

    public static PoseInfo getBestPoseTrackInfo() {
        if (activity.getPoseInfoArray() != null && activity.getPoseInfoArray().length > 0) {
            return activity.getPoseInfoArray()[0];
        }
        return null;
    }

    public static PoseInfo getOriginalBestPoseTrackInfo() {
        if (activity.getPoseInfoOrgArray() != null && activity.getPoseInfoOrgArray().length > 0) {
            return activity.getPoseInfoOrgArray()[0];
        }
        return null;
    }

    public static PoseInfo[] getRoiPersonTrackInfo() {
        return activity.getPoseInfoArray();
    }

    public static PoseInfo getIdPoseTrackIdInfo() {
        if (activity.getPoseInfoArray() != null && activity.getPoseInfoArray().length > 0) {
            return activity.getPoseInfoArray()[0];
        }
        return null;
    }

    public static PoseInfo[] getTwoPersonTrackInfo() {
        return activity.getPoseInfoArray();
    }

    public static HolisticInfo getHolisticInfo() {
        return activity.getHolisticInfo();
    }

    public static HolisticInfo getOriginalHolisticInfo() {
        return activity.getHolisticInfoOrg();
    }

    public static float[] getZeePointArray(String param) {
        return null;
    }

    public static float[] getOriginalZeePointArray(String param) {
        return null;
    }

    public static void setAndroidDebug(boolean debug) {
        activity.setDebugAndroid(debug);
    }
}

