/*
 * Decompiled with CFR 0.152.
 */
package com.zee.unity.utils;

import android.content.Context;
import android.graphics.Bitmap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CommonUtils {
    public static void saveBitmap(Bitmap b, String path) {
        String jpegName = path + System.currentTimeMillis() + ".jpg";
        try {
            FileOutputStream out = new FileOutputStream(jpegName);
            BufferedOutputStream bos = new BufferedOutputStream(out);
            b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean copyFilesFromAssetsTo(Context context, String[] fileNames, String dirPath) {
        try {
            for (String model : fileNames) {
                CommonUtils.copyAssetFileToFiles(context, model, dirPath);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void copyAssetFileToFiles(Context context, String filename, String dirPath) throws IOException {
        File of = new File(dirPath + filename);
        if (!of.exists()) {
            InputStream is = context.getAssets().open(filename);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            of.createNewFile();
            FileOutputStream os = new FileOutputStream(of);
            os.write(buffer);
            os.close();
            is.close();
        }
    }
}

